package gov.va.vinci.dart.db.mock;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.db.EventDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.ArrayList;
import java.util.List;

public class RequestEventSummaryDAOMock {

	private int requestId;
	
	public RequestEventSummaryDAOMock(int requestId) {
		this.requestId = requestId;
	}
	
	public List<EventSummary> build() {
		List<EventSummary> result = new ArrayList<EventSummary>();
		
		EventDAO mock = DartObjectFactory.getInstance().getEventDAO();
		
		for (Event event : mock.listByRequestId(requestId)) {
			EventSummary es = new EventSummary();
			es.setActivityId(event.getRequest().getActivity().getId());
			es.setRequestId(event.getRequest().getId());
			es.setDescription(event.getDescription());
			result.add(es);
		}
		
		return result;
	}
	
}
